//	 2005 Colter Reed, Procyon IT.  All rights reserved.
//	
//	This software is provided as-is with no warranty of any kind, express or implied.
//	You may reverse-engineer it to your heart's content to figure out how it works.
//	You may use any of this code in your own projects, provided that you give credit
//	to Colter Reed and Procyon IT.  If you make any modifications to this program,
//	especially bug fixes and new functions, send them to me -- we'll see if we can
//	incorporate them into a future version.
//	
//	Thanks, and have fun.

var stack = new Array();
var input = null;

var undo_stack = new Array();
var redo_stack = new Array();

var DEG   = Math.PI / 180;
var RAD   = 1;

var visRows = 6;

var BASE = 10;
var digits = "0123456789abcdefghijklmnopqrstuvwxyz";

var fractionalOperand = false;
var USE_COMMAS = false;
var FREEZE_DISPLAY = false;

function operation(op) {
	if (input != null) {
		commit();
	}
	
	if (typeof(op) == "string" && op.indexOf(" ") >= 0) {
		var ops = op.split(" ");
		//FREEZE_DISPLAY = true;
		for (var i in ops) {
		//	stack.push(ops[i]);
			operation(ops[i]);
		}
		//FREEZE_DISPLAY = false;
		return;
	}

	if (typeof(op) == "number" || op.match(/^[0-9\.,]+$/)) {
		stack.push(op);
		//c = op;
	} else {
		var c = null;
		switch (op.toLowerCase()) {
			case "add":
			case "+":
				if (stack.length > 1) {
					a = getOperand();
					b = getOperand();
					c = b + a;
					undo_stack.push( { remove:1, operands:[a,b] });
				} else {
					displayError(ERROR_TWO_OPERANDS);
				}
				break;
			case "sub":
			case "-":
				if (stack.length > 1) {
					a = getOperand();
					b = getOperand();
					c = b - a;
					undo_stack.push( { remove:1, operands:[a,b] });
				} else {
					displayError(ERROR_TWO_OPERANDS);
				}
				break;
			case "mult":
			case "*":
				if (stack.length > 1) {
					a = getOperand();
					b = getOperand();
					c = b * a;
					undo_stack.push( { remove:1, operands:[a,b] });
				} else {
					displayError(ERROR_TWO_OPERANDS);
				}
				break;
			case "div":
			case "/":
				if (stack.length > 1) {
					a = getOperand();
					if (a != 0) {
						b = getOperand();
						c = b / a;
						undo_stack.push( { remove:1, operands:[a,b] });
					} else {
						displayError(ERROR_DIVIDE_ZERO);
						stack.push(a);
					}
				} else {
					displayError(ERROR_TWO_OPERANDS);
				}
				break;
			case "sin":
				if (stack.length > 0) {
					a = getOperand();
					c = Math.sin( a * DEG );
					undo_stack.push( { remove:1, operands:[a] });
				} else {
					displayError(ERROR_ONE_OPERAND);
				}
				break;
			case "asin":
				if (stack.length > 0) {
					a = getOperand();
					c = Math.asin( a ) / DEG;
					undo_stack.push( { remove:1, operands:[a] });
				} else {
					displayError(ERROR_ONE_OPERAND);
				}
				break;
			case "cos":
				if (stack.length > 0) {
					a = getOperand();
					c = Math.cos( a * DEG );
					undo_stack.push( { remove:1, operands:[a] });
				} else {
					displayError(ERROR_ONE_OPERAND);
				}
				break;
			case "acos":
				if (stack.length > 0) {
					a = getOperand();
					c = Math.acos( a ) / DEG;
					undo_stack.push( { remove:1, operands:[a] });
				} else {
					displayError(ERROR_ONE_OPERAND);
				}
				break;
			case "tan":
				if (stack.length > 0) {
					a = getOperand() ;
					c = Math.tan( a* DEG );
					undo_stack.push( { remove:1, operands:[a] });
				} else {
					displayError(ERROR_ONE_OPERAND);
				}
				break;
			case "atan":
				if (stack.length > 0) {
					a = getOperand();
					c = Math.atan( a ) / DEG;
					undo_stack.push( { remove:1, operands:[a] });
				} else {
					displayError(ERROR_ONE_OPERAND);
				}
				break;

			case "swap":
			case "~":
				if (stack.length > 1) {
					a = stack.pop();
					b = stack.pop();
					stack.push(a);
					stack.push(b);
					undo_stack.push( { remove:2, operands:[a,b] });
				} else {
					displayError(ERROR_TWO_OPERANDS);
				}
				break;
			
			case "roll":
				if (stack.length > 1) {
					revstack = stack.slice(0);
					revstack.reverse();
					undo_stack.push( { cache:stack.slice(0) } );
					stack = roll(stack);
				}
				break;
			
			case "rolld":
				if (stack.length > 1) {
					
					undo_stack.push( { cache:stack.slice(0) } );
					stack = rolld(stack);
				}
				break;
			
			case "rolln":
				if (stack.length > 1) {
					undo_stack.push( { cache:stack.slice(0) } );
					n = stack.pop();
					mod = stack.splice(stack.length - n, n);
					stack = stack.concat( roll(mod) );
				}
				break;
			
			case "rolldn":
				if (stack.length > 1) {
					undo_stack.push( { cache:stack.slice(0) } );
					n = stack.pop();
					mod = stack.splice(stack.length - n, n);
					stack = stack.concat( rolld(mod) );
				}
				break;
			
			case "dup":
				if (stack.length > 0) {
					a = stack.pop();
					stack.push(a);
					stack.push(a);
					undo_stack.push( { remove:1 } );
				}
				break;
			
			case "dupn":
				if (stack.length > 0) {
					n = stack.pop();
					mod = stack.splice(stack.length - n, n);
					stack = stack.concat(mod,mod);
					undo_stack.push( { remove:n, operands:[n] } );
				}
				break;
			
			case "drop":
				if (stack.length > 0) {
					a = stack.pop();
					undo_stack.push( { operands:[a] } );
				}
				break;
			
			case "dropn":
				if (stack.length > 0) {
					cache = new Array();
					n = stack.pop();
					cache.push(n);
					cl = stack.length;
					n = Math.min(n,cl);
					for (var i=0; i < n ; i++) {
						a = stack.pop();
						cache.push( a );
					}
					undo_stack.push( {cache:cache} );
				}
				break;
			
			case "pick":
				if (stack.length > 0) {
					n = getOperand();
					l = stack.length;
					t = l - n;
					//stack.push("n: " + n);
					//stack.push("l: " + l);
					//stack.push("t: " + t);
					if (n <= stack.length && n > 0) {
						stack.push( stack[t] );
					}
					undo_stack.push( {remove:1, operands:[n]} );
				}
				break;
			case "sqr":
				if (stack.length > 0) {
					a = getOperand();
					c = a * a;
					undo_stack.push( {remove:1, operands:[a]} );
				} else {
					displayError(ERROR_ONE_OPERAND);
				}
				break;
			case "sqrt":
				if (stack.length > 0) {
					a = getOperand();
					if (a >= 0) {
						stack.push( Math.pow(a,0.5) );
						undo_stack.push( {remove:1, operands:[a]} );
					} else {
						displayError(ERROR_IMAGINARY);
						stack.push(a);
					}
				} else {
					displayError(ERROR_ONE_OPERAND);
				}
				break;
			case "pow":
				if (stack.length > 1) {
					a = getOperand();
					b = getOperand();
					if (a >= 1 || b >= 0) {
						stack.push(Math.pow(b,a));
						undo_stack.push( {remove:1, operands:[a,b]} );
					} else {
						displayError(ERROR_IMAGINARY);
						stack.push(b);
						stack.push(a);
					}
				} else {
					displayError(ERROR_TWO_OPERANDS);
				}
				break;
				
			case "nroot":
				if (stack.length > 1) {
					a = getOperand();
					b = getOperand();
					if (b >= 0) {
						c = Math.pow(b,1/a);
						undo_stack.push( {remove:1, operands:[a,b]} );
					} else {
						displayError(ERROR_IMAGINARY);
						stack.push(b);
						stack.push(a);
					}
				} else {
					displayError(ERROR_TWO_OPERANDS);
				}
				break;
			
			case "flip":
				if (stack.length > 0) {
					a = getOperand();
					stack.push( 1 / a );
					undo_stack.push( {remove:1, operands:[a]} );
				} else {
					displayError(ERROR_ONE_OPERAND);
				}
				break;
			
			case "neg":
			case "_":
			case "@":
				if (stack.length > 0) {
					a = getOperand();
					stack.push( a * -1 );
					undo_stack.push( {remove:1, operands:[a]} );
				} else {
					displayError(ERROR_ONE_OPERAND);
				}
				break;
				
			case "exp":
				if (stack.length > 0) {
					a = getOperand();
					stack.push( Math.exp(a) );
					undo_stack.push( {remove:1, operands:[a]} );
				} else {
					displayError(ERROR_ONE_OPERAND);
				}
				break;
			
			case "10x":
				if (stack.length > 0) {
					a = getOperand();
					stack.push( Math.pow(10,a) );
					undo_stack.push( {remove:1, operands:[a]} );
				} else {
					displayError(ERROR_ONE_OPERAND);
				}
				break;
			
			case "log":
				if (stack.length > 0) {
					a = getOperand();
					stack.push( Math.log(a) / Math.log(10));
					undo_stack.push( {remove:1, operands:[a]} );
				} else {
					displayError(ERROR_ONE_OPERAND);
				}
				break;
				
			case "ln":
				if (stack.length > 0) {
					a = getOperand();
					stack.push( Math.log(a) );
					undo_stack.push( {remove:1, operands:[a]} );
				} else {
					displayError(ERROR_ONE_OPERAND);
				}
				break;
				
			case "rotl":
			case "[":
				if (stack.length > 0) {
					a = getOperand();
					undo_stack.push( {remove:1, operands:[a]} );
					b = a & 0x80000000;
					a = a & 0x7FFFFFFF;
					a = a << 1;
					if (b) {
						a = a | 1;
					}
					stack.push(a);
				} else {
					displayError(ERROR_ONE_OPERAND);
				}
				break;
			
			case "rotr":
			case "]":
				if (stack.length > 0) {
					a = getOperand();
					undo_stack.push( {remove:1, operands:[a]} );
					b = a & 0x00000001;
					a = a & 0xFFFFFFFE;			// Why is that high bit staying set?
					a = a >>> 1;				// Zero-fill shift
					if (b) {
						a = a | 0x80000000;
					}
					stack.push(a);
				} else {
					displayError(ERROR_ONE_OPERAND);
				}
				break;
			
			case "shftl":
			case "{":
				if (stack.length > 0) {
					a = getOperand();
					undo_stack.push( {remove:1, operands:[a]} );
					a = a << 1;
					stack.push(a);
				} else {
					displayError(ERROR_ONE_OPERAND);
				}
				break;
			
			case "shftr":
			case "}":
				if (stack.length > 0) {
					a = getOperand();
					undo_stack.push( {remove:1, operands:[a]} );
					a = a >>> 1;				// Zero-fill shift
					stack.push(a);
				} else {
					displayError(ERROR_ONE_OPERAND);
				}
				break;
			
			case "frac":
			case "\\":
				if (stack.length > 0) {
					a = getOperand();
					if (fractionalOperand) {
						stack.push( a );
						fractionalOperand = false;
					} else {
						stack.push( parseFraction(a) );
					}
				} else {
					displayError(ERROR_ONE_OPERAND);
				}
				break;
			
			case "round":
				if (stack.length > 0) {
					a = getOperand();
					undo_stack.push( {remove:1, operands:[a]} );
					c = Math.round(a);
				} else {
					displayError(ERROR_ONE_OPERAND);
				}
				break;
			
			case "and":
			case "&":
				if (stack.length > 0) {
					a = getOperand();
					b = getOperand();
					c = a & b;
					undo_stack.push( {remove:1, operands:[a,b]} );
				} else {
					displayError(ERROR_ONE_OPERAND);
				}
				break;
			
			case "or":
			case "|":
				if (stack.length > 0) {
					a = getOperand();
					b = getOperand();
					c = a | b;
					undo_stack.push( {remove:1, operands:[a,b]} );
				} else {
					displayError(ERROR_ONE_OPERAND);
				}
				break;
			
			case "xor":
			case "^":
				if (stack.length > 0) {
					a = getOperand();
					b = getOperand();
					c = a ^ b;
					undo_stack.push( {remove:1, operands:[a,b]} );
				} else {
					displayError(ERROR_ONE_OPERAND);
				}
				break;
			
			case "!":
				if (stack.length > 0) {
					a = getOperand();
					c = -(a+1);
					undo_stack.push( {remove:1, operands:[a]} );
				} else {
					displayError(ERROR_ONE_OPERAND);
				}
				break;
			
			case "dec":
				setBase(10);
				break;
			
			case "hex":
				setBase(16);
				break;
			
			case "oct":
				setBase(8);
				break;
			
			case "bin":
				setBase(2);
				break;
			
			case "base":
				if (stack.length > 0) {
					a = getOperand();
					setBase(a);
				}
				break;
			
			case "undo":
				if (undo_stack.length > 0) {
					redo_stack.push( undoredo( undo_stack.pop() ) );
				} else {
					displayError(ERROR_CANT_UNDO);
				}
				break;
			
			case "redo":
				if (redo_stack.length > 0) {
					undo_stack.push( undoredo( redo_stack.pop() ) );
				} else {
					displayError(ERROR_CANT_REDO);
				}
				break;
			
			default:
				stack.push(op);
		}
	}
	
	if (c != null) {
		c = approx(c);
		stack.push(c);
	}
	
	//if (!FREEZE_DISPLAY)
		updateDisplay();
	
	if (showingInvs)
		showInvs(false);
		
	if (fractionalOperand) {
		fractionalOperand = false;
		operation("frac");
	}
	
	if (op != "undo" && op != "redo") {
		redo_stack = new Array();
	}
}

function undoredo(undo) {
	var redo = new Array();
	
	if (undo.cache) {
		redo.cache = stack.slice(0);
		stack = undo.cache;
	} else {
		if (undo.remove) {
			var operands = new Array();
			for(var i=0; i < undo.remove; i++) {
				a = stack.pop();
				operands.push(a);
			}
			redo.operands = operands;
		}
		
		if (undo.operands) {
			redo.remove = undo.operands.length;
			while(a = undo.operands.pop()) {
				stack.push(a);
			}
		}
	}
	return redo;
}

function setBase(n) {
	switch(n) {
		case 2:
			label = "bin";
			break;
		
		case 8:
			label = "oct";
			break;
		
		case 10:
			label = "dec";
			break;
		
		case 16:
			label = "hex";
			break;
		
		default:
			label = "base " + n;
			break;
	}
	
	BASE = n;
	document.getElementById("baseDisplay").innerHTML = label;
}

function approx(n) {
	strn = n + "";
	if (strn.indexOf(".") < 0) {			// If there's no fractional part
		//alert("No . -- bailing");
		return n;						// Just return it -- it's already close ;)
	}
	
	//alert("approxing");
	if (m = strn.match(/(.+\..+)(0{4,}[0-9]+$)/)) {
		return parseFloat(m[1]);		//	Just return the first part, without the offending fractional
	}
	
	if (m = strn.match(/(.+)\.(.+)(9{4,}[0-9]+$)/)) {
		offender = m[3];
		ceiling = Math.pow(10,offender.length);
		offset = ceiling - offender;
		
		places = (m[2] + "" + m[3]).length;			// Add the "" to force strings
		offset *= Math.pow(10,-1 * places);
		
		newn = n + offset;
		//stack.push("Offender:" + offender);
		//stack.push("ceiling :" + ceiling);
		//stack.push("offset  :" + offset);
		//stack.push("frac    :" + (m[2] + "" + m[3]));
		return parseFloat(newn);
	}
	
	return n;		// Well, we tried
}

function keyPress(k) {
	beginEditing();
	if (k == ',') {
		USE_COMMAS = true;
		k = ".";
	} else if (k=='.') {
		USE_COMMAS = false;
	}
	if (k == "." && input.indexOf(".") >= 0) {
		return false;
	}
	if (k == "." && input.length == 0) {
		input += "0";		//	So we can type "." and get "0." out of it
	}
	kval = digits.indexOf(k.toLowerCase());
	if ((kval >= 0 && kval < BASE) || k == ".") {
		input += "" + k ;
	}
	setTop(input);
	updateDisplay();
}

function clear() {
	input = input.substring(0,input.length-1);
	updateDisplay();
}

function drop() {
	input = null;
	stack.pop();
	updateDisplay();
}

function keyhandler(e) {
	c = String.fromCharCode(e.which);
	if (e.metaKey) {
		if (c == 'z') {
			operation(e.shiftKey ? "redo" : "undo");
		} else if (c == 'd') {
			operation("dup");
		} else if (c == ',') {
			//showBack();
		} else {
			return true;		// Return for the rest of them
		}
		e.preventDefault();
		return false;
	}
	
	if (false) {
		stack.push(e.which);
		updateDisplay();
		return;
	}
	
	if ("0123456789abcdef.,".indexOf(c.toLowerCase()) >= 0) {
		keyPress(c);
		return false;
	} else if (c == "\x08") {
		if (e.shiftKey || input == null) {
			drop();
		} else {
			clear();
		}
		return false;
	} else if (c == " " || c == "\x0D" || c == "\x03") {
		if (input) {
			commit();
		} else {
			operation("dup");
		}
		return false;
	} else if (e.which == 63276) {
		operation( "roll" );
		return false;
	} else if (e.which == 63277) {
		operation( "rolld" );
		return false;
	} else if ("+-*/[]_&|^~\\!@{}".indexOf(c) >= 0) {
		operation( c );
		return false;
	} else if (e.which > 60000) {
		//stack.push(e.which);
		updateDisplay();
		return false;
	}
	
	return true;		// Somebody else can handle it
}

function commit() {
	endEditing();
	undo_stack.push( { remove:1 } );
	redo_stack = new Array();
}

function beginEditing() {
	if (input == null) {
		//alert("Initialized stack entry");
		stack.push("");
		input = "";
	}
}

function getOperand() {
	x = stack.pop();
	if (typeof(x) == "string" && x.indexOf("/") > 0) {
		x = parseFromFraction(x);
		fractionalOperand = true;
	}
	return x * 1.0;
}

function setTop(x) {
	stack[ stack.length - 1 ] = x;
}

function endEditing() {
	if (input) {
		if (BASE == 10) {
			setTop(parseFloat(input));
		} else {
			setTop(parseInt(input,BASE));
		}
		input = null;
		updateDisplay();
	}
}

function updateDisplay() {
	if (input) {
		setTop(input);
	}
	if (stack.length == 0 && !input) {
		//stack.push(0);
		visible = 0;
	} else {
		if (input) {
		//	We're editing the top number.  Show it in red
			start = stack.length > visRows ? stack.length - visRows : 0;
			end   = stack.length - 1;
			visnums = showInBase(stack.slice(start,end));
			visible = visnums.join("<br />");
			visible += "<br />";
			visible += "<span style='color:#333333'>" + input + "</span>";
		} else {
			start = stack.length > visRows ? stack.length - visRows : 0;
			end   = stack.length;
			visNums = showInBase(stack.slice(start,end));
			visible = visNums.join("<br />");
		}
	}
	if (USE_COMMAS) {
		visible = visible.replace(/\./g,",");
	}
	document.getElementById("screenCell").innerHTML = visible;
}

function showInBase(a) {
	if (BASE != 10) {
		for(i=0; i < a.length; i++) {
			a[i] = a[i].toString(BASE).toUpperCase();
		}
	}
	return a;
}

/*
 *	Clipboard Wizardry
 *
 */

function docut(e) {
	docopy(e);
	stack.pop();
	updateDisplay();
	e.preventDefault();
	e.stopPropagation();
}

function docopy(e) {
	if (stack.length > 0) {
		altStack = showInBase(stack);
		e.clipboardData.setData('text/plain',altStack[altStack.length-1]);
		updateDisplay();
	}
	e.preventDefault();
	e.stopPropagation();
}

function dopaste(e) {
	a = e.clipboardData.getData('text/plain');
	
//	Try parsing the number in the current base
	n = parseInt(a,BASE);
	
//	No?  try grabbing it as a float
	if (!n)
		n = parseFloat(a);
	
//	No?  Umm....
	if (!n)
		n = 42;
	
	if (input) {
		input += n;
	} else {
		stack.push(n);
	}
	updateDisplay();
	
}

/*
 *	focus/unfocus stuff
 *
 */

function onfocus() {
	document.getElementById("screenCell").setAttribute("class","screenOn");
	updateDisplay();
}

function onblur() {
	document.getElementById("screenCell").setAttribute("class","screenOff");
	updateDisplay();
}

/*
 *	for debugging stuff
 *
 */

function msg(str) {
	div = document.getElementById("console");
	if (div) {
		div.innerHTML += str;
	}
}
